/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskProperties;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.base.VWDebug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VWTaskApplicationSettings {
    private String m_defaultXMLPath = null;
    private String m_defaultPropertiesPath = null;
    private VWTaskProperties m_defaultProperties = null;
    private HashMap m_propertiesMap = new HashMap(5);
    private HashMap m_xmlPathMap = new HashMap(5);
    private HashMap m_xmlHandlerMap = new HashMap(5);
    private HashMap m_xmlErrorMap = new HashMap(5);
    private static VWTaskApplicationSettings m_instance = null;

    public static synchronized VWTaskApplicationSettings getInstance() {
        if (m_instance == null) {
            m_instance = new VWTaskApplicationSettings();
        }
        return m_instance;
    }

    private VWTaskApplicationSettings() {
        try {
            this.init();
        }
        catch (Exception ex) {
            VWDebug.logException(ex, "Exception occurred while initializing VWTaskApplicationSettings.");
            VWTaskCore.getInstance().displayError(ex);
        }
    }

    public synchronized VWTaskXMLHandler getXMLHandler() {
        return this.getXMLHandler(null);
    }

    public synchronized VWTaskXMLHandler getXMLHandler(String propertiesPath) {
        String xmlPath = null;
        xmlPath = propertiesPath == null ? this.m_defaultXMLPath : (String)this.m_xmlPathMap.get(propertiesPath);
        if (xmlPath == null || this.m_xmlErrorMap.containsKey(xmlPath)) {
            return null;
        }
        VWTaskXMLHandler xmlHandler = (VWTaskXMLHandler)this.m_xmlHandlerMap.get(xmlPath);
        if (xmlHandler == null) {
            try {
                xmlHandler = new VWTaskXMLHandler(xmlPath);
                this.m_xmlHandlerMap.put(xmlPath, xmlHandler);
            }
            catch (Exception e) {
                this.m_xmlErrorMap.put(xmlPath, null);
                VWTaskCore.getInstance().displayError(e);
                VWDebug.logInfo("Could not read application settings file: " + xmlPath + ". Error: " + e.getLocalizedMessage());
            }
        }
        return xmlHandler;
    }

    public String getXMLPath(String propertiesPath) {
        return (String)this.m_xmlPathMap.get(propertiesPath);
    }

    public VWTaskProperties getProperties() {
        return this.m_defaultProperties;
    }

    public String getDefaultPropertiesPath() {
        return this.m_defaultPropertiesPath;
    }

    public VWTaskProperties getProperties(String path) {
        return (VWTaskProperties)this.m_propertiesMap.get(path);
    }

    public HashMap getPropertiesMap() {
        return (HashMap)this.m_propertiesMap.clone();
    }

    public int getApplicationRegistryPort() {
        int port = 32771;
        try {
            VWTaskXMLHandler xmlHandler = this.getXMLHandler();
            if (xmlHandler != null) {
                Element ele;
                Node node = VWTaskXMLHandler.getNodeNamed(xmlHandler.getRootNode(), "Root");
                if (node != null && node.getNodeType() == 1 && (ele = (Element)node).getAttributeNode("RegistryPort") != null) {
                    port = Integer.parseInt(ele.getAttribute("RegistryPort"));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex, "Error parsing application port number.");
        }
        return port;
    }

    public synchronized void updateApplicationSettings(HashMap xmlBufferMap) throws Exception {
        for (String xmlPath : xmlBufferMap.keySet()) {
            this.writeApplicationXML(xmlPath, xmlBufferMap.get(xmlPath).toString());
            this.m_xmlHandlerMap.put(xmlPath, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeApplicationXML(String filePath, String fileContents) throws Exception {
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(filePath);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)ostream, "UTF8");
            out.write(fileContents);
            ((Writer)out).flush();
        }
        finally {
            if (ostream != null) {
                try {
                    ((OutputStream)ostream).close();
                }
                catch (Exception E) {}
                ostream = null;
            }
        }
    }

    private void init() throws Exception {
        File file = new File(System.getProperty("TaskManager.Properties")).getAbsoluteFile();
        this.m_defaultProperties = VWTaskProperties.getInstance(file.getPath());
        this.m_defaultXMLPath = this.getDefaultXMLPath();
        this.m_defaultPropertiesPath = file.getCanonicalPath();
        this.m_propertiesMap.put(this.m_defaultPropertiesPath, this.m_defaultProperties);
        this.m_xmlPathMap.put(this.m_defaultPropertiesPath, this.m_defaultXMLPath);
        if (this.m_defaultProperties.getBoolean("TaskManager.Debug")) {
            VWTaskProperties.logProperties(this.m_defaultPropertiesPath, this.m_defaultProperties);
        }
        if (this.m_defaultProperties.getBoolean("TaskManager.ConsolidatedView") && !Boolean.getBoolean("TaskManager.AutoStart") && !Boolean.getBoolean("TaskManager.AutoStop")) {
            try {
                VWDebug.logInfo("Performing consolidated view initialization for application settings.");
                String instancesXML = VWTaskUtil.removeTrailingSlash(this.m_defaultProperties.getProperty("TaskManager.P8TASKMAN_HOME")) + File.separator + "taskmaninstances.xml";
                VWTaskXMLHandler xmlHandler = new VWTaskXMLHandler(instancesXML);
                Node[] nodes = VWTaskXMLHandler.getNodesNamed(xmlHandler.getRootNode(), "Product");
                if (nodes != null) {
                    for (int i = 0; i < nodes.length; ++i) {
                        String productName = null;
                        try {
                            VWTaskProperties p;
                            Element ele = (Element)nodes[i];
                            productName = ele.getAttribute("name");
                            VWDebug.logInfo("Loading product: " + productName);
                            File propsFile = new File(VWTaskXMLHandler.getXMLString(VWTaskXMLHandler.getNodeNamed(ele, "properties"))).getCanonicalFile();
                            String propertiesPath = propsFile.getPath();
                            if (!propsFile.exists() || this.m_propertiesMap.get(propertiesPath) != null || !(p = VWTaskProperties.getInstance(propertiesPath)).getBoolean("TaskManager.ConsolidatedView")) continue;
                            this.loadProduct(propsFile);
                            continue;
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex, "Exception initializing product: " + productName);
                        }
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex, "Exception initializing consolidated view properties.");
            }
        }
        if (this.m_defaultProperties.getBoolean("TaskManager.Debug")) {
            VWTaskProperties.logProperties("System", System.getProperties());
        }
    }

    private void loadProduct(File propsFile) throws Exception {
        String propertiesPath = propsFile.getPath();
        VWTaskProperties p = VWTaskProperties.getInstance(propertiesPath);
        VWTaskProperties.initSystemProperties(p);
        String vwtaskmanXMLPath = null;
        String haDirPath = p.getProperty("TaskManager.HASharedDirectory", null);
        if (haDirPath != null) {
            File haDir = new File(haDirPath);
            if (!haDir.exists() || !haDir.isDirectory()) {
                throw new VWException("filenet.vw.apps.taskman.VWTaskApplicationSettings.SubProduct", "Invalid high availability directory specified in taskman.properties. Property: {0}, Directory {1}", "TaskManager.HASharedDirectory", haDir.getAbsolutePath());
            }
            vwtaskmanXMLPath = VWTaskUtil.removeTrailingSlash(haDir.getAbsolutePath()) + File.separator + "vwtaskman.xml";
        } else {
            vwtaskmanXMLPath = VWTaskUtil.removeTrailingSlash(propsFile.getParent()) + File.separator + "vwtaskman.xml";
        }
        this.m_propertiesMap.put(propertiesPath, p);
        this.m_xmlPathMap.put(propertiesPath, vwtaskmanXMLPath);
        if (this.m_defaultProperties.getBoolean("TaskManager.Debug")) {
            VWTaskProperties.logProperties(propertiesPath, p);
        }
    }

    private String getDefaultXMLPath() throws VWException {
        String xmlPath = null;
        String previousLoc = "vwtaskman.xml";
        String fnsw_loc = this.m_defaultProperties.getProperty("TaskManager.ProcessService.FnswLoc", "");
        if (!fnsw_loc.equals("")) {
            previousLoc = VWTaskUtil.removeTrailingSlash(fnsw_loc) + File.separator + "sd" + File.separator + previousLoc;
        }
        xmlPath = previousLoc;
        String propertiesLoc = System.getProperty("TaskManager.Properties", null);
        if (propertiesLoc != null) {
            String haDirPath = this.m_defaultProperties.getProperty("TaskManager.HASharedDirectory", null);
            if (haDirPath != null) {
                File haDir = new File(haDirPath);
                if (!haDir.exists() || !haDir.isDirectory()) {
                    throw new VWException("filenet.vw.apps.taskman.VWTaskApplicationSettings", "Invalid high availability directory specified in taskman.properties. Property: {0}, Directory {1}", "TaskManager.HASharedDirectory", haDir.getAbsolutePath());
                }
                xmlPath = VWTaskUtil.removeTrailingSlash(haDir.getAbsolutePath()) + File.separator + "vwtaskman.xml";
            } else {
                File sourceFile;
                xmlPath = VWTaskUtil.removeTrailingSlash(new File(propertiesLoc).getAbsoluteFile().getParent()) + File.separator + "vwtaskman.xml";
                File destinationFile = new File(xmlPath);
                if (!destinationFile.exists() && (sourceFile = new File(previousLoc)).exists()) {
                    this.moveApplicationFile(sourceFile, destinationFile);
                }
            }
        }
        VWDebug.logInfo("Location of vwtaskman.xml: " + xmlPath);
        return xmlPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveApplicationFile(File source, File destination) {
        BufferedReader reader = null;
        try {
            VWDebug.logInfo("Moving file " + source.getPath() + " to " + destination.getPath());
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), "UTF8"));
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            this.writeApplicationXML(destination.getPath(), buffer.toString());
            reader.close();
            reader = null;
            source.delete();
        }
        catch (Exception ex) {
            VWDebug.logException(ex, "Exception while moving application file.");
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   26 Sep 2008 19:52:04  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.13  $";
    }
}

